﻿$(document).on("pageinit", function () {
    var context = $("[data-questiontype='imageselector'], [data-questiontype='imagechoicegrid'], [data-questiontype='hybridgrid']");

    var toggleChoices = function (choice) {
        var choiceList = choice.closest(".ui-controlgroup");
        var checkBox = $(":checkbox", choice);

        var maxAnswers = choiceList.attr("data-maxanswers");

        $(".choice", choiceList).each(function () {
            $(this).removeClass("disabled");
        });

        var selectedCheckBoxes = $('.choiceImage.selectedImageChoice :checkbox[name=' + checkBox.attr('name') + ']', choiceList);
        var choicesToDisable;

        if (selectedCheckBoxes.length > 0) {
            var isExclusive = checkBox.is("[data-exclusive=true]");

            if (isExclusive || maxAnswers == 1) {
                choicesToDisable = $('.choiceImage :checkbox[name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']', choiceList);
            }
            else if (maxAnswers != null && maxAnswers > 1 && selectedCheckBoxes.length >= maxAnswers) {
                choicesToDisable = $('.choiceImage:not(.selectedImageChoice) :checkbox[name=' + checkBox.attr('name') + ']', choiceList);
            }
            else {
                choicesToDisable = $('.choiceImage :checkbox[data-exclusive=true][name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']', choiceList)
            }
        }

        if (choicesToDisable) {
            choicesToDisable.each(function () {
                $(this).prop("checked", false);
                $(this).closest(".choiceImage").removeClass("selectedImageChoice");

                if (maxAnswers > 1) {
                    $(this).closest(".choice").toggleClass("disabled", true);
                }

                ToggleOpenEndMobile($(this));
            });
        }
    };

    $(".ui-controlgroup", context).each(function () {
        var firstSelectedChoice = $(".choiceImage.selectedImageChoice", $(this)).first();

        if (firstSelectedChoice.length > 0) {
            toggleChoices(firstSelectedChoice.closest(".choice"));
        }
    });

    context.on("click", ".imageChoice .choice:not(.disabled) .choiceImage", function () {
        var choiceImage = $(this);
        var choice = choiceImage.closest(".choice");
        var checkBox = choice.find(":checkbox");

        var isChecked = !checkBox.is(":checked");

        checkBox.prop("checked", isChecked);

        choiceImage.toggleClass("selectedImageChoice", isChecked);

        ToggleOpenEndMobile(checkBox);

        checkBox.trigger("change");

        toggleChoices(choice);
    });
});